const DEFAULTS = {
  welcomeMessage: "Hey! 😊 How's it going?",
  waitSeconds: 20,
  debug: false
};

function $(id){ return document.getElementById(id); }

function load() {
  chrome.storage.sync.get(DEFAULTS, (cfg) => {
    $("welcomeMessage").value = cfg.welcomeMessage;
    $("waitSeconds").value = cfg.waitSeconds;
    $("debug").value = String(cfg.debug);
  });
}

function save() {
  const payload = {
    welcomeMessage: $("welcomeMessage").value.trim() || DEFAULTS.welcome